import 'package:custom_radio_grouped_button/custom_radio_grouped_button.dart';
import 'package:springcontrol/card_ladebegrenzung.dart';
import 'package:springcontrol/globalsclient.dart';
import 'package:daciapackete/globals.dart' as globals;
import 'package:daciapackete/speicherdaten.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:daciapackete/ladeklimakonfig.dart';
import 'main.dart';
import 'package:daciapackete/config.dart';
// WICHTIG: Korrekter Import deines CustomRadioButtonWithEdit Widgets!

import "package:springcontrol/cards/radioButtonProgrammAuswahl.dart";

class FormLadeprogramm extends StatefulWidget {
  FormLadeprogramm() : super(key: globalkey);

  @override
  State<FormLadeprogramm> createState() => _FormLadeprogrammState();
}

class _FormLadeprogrammState extends State<FormLadeprogramm> {
  final _formKey = GlobalKey<FormState>();

  // NEU: Diese Variablen speichern die KOPIEN im State.
  // Sie werden nur einmal initialisiert und behalten ihren Wert.
  late Config _localConfig; // Verwende late, da im initState initialisiert wird
  late LadeKlimaKonfig _localLadeKlimaKonfig;


  @override
  void initState() {
    super.initState();
    // Kopien beim Initialisieren des States erstellen
    _localConfig = globals.config.copy();
    _localLadeKlimaKonfig = globals.ladeKlimaKonfig.copy();
  }


  @override
  Widget build(BuildContext context) {
    // KEINE Kopien mehr hier erstellen!
    // Stattdessen die _localConfig und _localLadeKlimaKonfig verwenden.
    var setDateTime = _localLadeKlimaKonfig.ladenDatumZeit;


    datenSpeichern() async {
      // Beim Speichern die geänderten lokalen Kopien den globalen Objekten zuweisen.
      globals.config = _localConfig;
      globals.ladeKlimaKonfig = _localLadeKlimaKonfig;
      await speicherDaten("config");
      await speicherDaten("ladeKlimaKonfig");
    }


    final size = MediaQuery.of(context).size;
    return PopScope(
        onPopInvokedWithResult: (didPop, result) async {
          await datenSpeichern();
          //dispose(); // Normalerweise nicht im PopScope aufrufen
        },
        child: Scaffold(
            appBar: AppBar(
              title: Text(context.sp.ladekonfiguration),
              centerTitle: true,
              backgroundColor: Theme.of(context).colorScheme.inversePrimary,
            ),
            body: Center(
                child: SingleChildScrollView(
                  child: Form(
                    key: _formKey,
                    child: Column(children: [
                      // Pass _localConfig and implement callback
                      CardLadebegrenzung(
                        config: _localConfig,
                        onLadebegrenzungChanged: (newConfig) {
                          setState(() {
                            _localConfig = newConfig;
                          });
                        },
                      ),
                      Card(
                        child: Padding(
                          padding: const EdgeInsets.all(8),
                          child: Column(
                            children: <Widget>[
                              ListTile(
                                title: Text(context.sp.ladeprogramm),
                              ),

                              Card(
                                child: Padding(
                                  padding: const EdgeInsets.all(8),
                                  child: Row(
                                    mainAxisAlignment:
                                    MainAxisAlignment.spaceBetween,
                                    children: [
                                      Text(context.sp.ladenstartenImmerAktiv),
                                      Switch(
                                        activeColor: Colors.green,
                                        activeTrackColor: Colors.grey.shade400,
                                        inactiveThumbColor: Colors.red.shade600,
                                        inactiveTrackColor: Colors.grey.shade400,
                                        value: _localConfig.ladestartImmerAktiv, // NUTZE DIE LOKALE KOPIE
                                        onChanged: (val) {
                                          setState(() {
                                            _localConfig.ladestartImmerAktiv = val; // ÄNDERE DIE LOKALE KOPIE
                                          });
                                        },
                                      ),
                                    ],
                                  ),
                                ),
                              ),
                              Card(
                                  child: Padding(
                                    padding: const EdgeInsets.all(8),
                                    child: Row(
                                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                      children: [
                                        Text(context.sp.ladegrenzeImmerAktiv),
                                        Switch(
                                          activeColor: Colors.green,
                                          activeTrackColor: Colors.grey.shade400,
                                          inactiveThumbColor: Colors.red.shade600,
                                          inactiveTrackColor: Colors.grey.shade400,
                                          value: _localConfig.ladegrenzeImmerAktiv, // NUTZE DIE LOKALE KOPIE
                                          onChanged: (val) {
                                            setState(() {
                                              _localConfig.ladegrenzeImmerAktiv = val; // ÄNDERE DIE LOKALE KOPIE
                                            });
                                          },
                                        ),
                                      ],
                                    ),
                                  )),
                              Card(
                                  child: Padding(
                                    padding: const EdgeInsets.all(8),
                                    child: Row(
                                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                      children: [
                                        Text(context.sp.abschaltung100PDurchApp),
                                        Switch(
                                          activeColor: Colors.green,
                                          activeTrackColor: Colors.grey.shade400,
                                          inactiveThumbColor: Colors.red.shade600,
                                          inactiveTrackColor: Colors.grey.shade400,
                                          value: _localConfig.app100PAbschaltung, // NUTZE DIE LOKALE KOPIE
                                          onChanged: (val) {
                                            setState(() {
                                              _localConfig.app100PAbschaltung = val; // ÄNDERE DIE LOKALE KOPIE
                                            });
                                          },
                                        ),
                                      ],
                                    ),
                                  )),

                              Card(
                                  child: Padding(
                                    padding: const EdgeInsets.all(8),
                                    child: Row(
                                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                      children: [
                                        Text(context.sp.externeLadesteuerungErlauben),
                                        Switch(
                                          activeColor: Colors.green,
                                          activeTrackColor: Colors.grey.shade400,
                                          inactiveThumbColor: Colors.red.shade600,
                                          inactiveTrackColor: Colors.grey.shade400,
                                          value: _localLadeKlimaKonfig.externErlaubt, // NUTZE DIE LOKALE KOPIE
                                          onChanged: (val) {
                                            setState(() {
                                              _localLadeKlimaKonfig.externErlaubt = val; // ÄNDERE DIE LOKALE KOPIE
                                            });
                                          },
                                        ),
                                      ],
                                    ),
                                  )),

                              CustomRadioButtonWithEdit(
                                ladeKlimaKonfig: _localLadeKlimaKonfig, // ÜBERGIB DIE LOKALE KOPIE
                                config: _localConfig, // ÜBERGIB DIE LOKALE KOPIE
                                onBeendenXAmChanged: (newValue) {
                                  // Der Callback vom Child wird aufgerufen.
                                  // Wir aktualisieren den Zustand im Parent (dieses Widget).
                                  setState(() {
                                    _localConfig.beendenXAm = newValue; // ÄNDERE DIE LOKALE KOPIE DES PARENT-WIDGETS
                                  });
                                },
                              ),

                              const SizedBox(
                                height: 10,
                              ),
                              CustomRadioButton(
                                buttonTextStyle: const ButtonTextStyle(
                                  selectedColor: Colors.white,
                                  unSelectedColor: Colors.black,
                                  textStyle: TextStyle(
                                    fontSize: 15,
                                  ),
                                ),
                                autoWidth: true,
                                enableButtonWrap: true,
                                wrapAlignment: WrapAlignment.center,
                                unSelectedColor: Theme.of(context).canvasColor,
                                buttonLables: const [
                                  "Wiederholung",
                                  "Einmalig",
                                ],
                                buttonValues: const [
                                  true,
                                  false,
                                ],
                                radioButtonValue: (values) {
                                  // Hier direkt die lokale Kopie ändern
                                  setState(() {
                                    _localLadeKlimaKonfig.wiederholungLadeprogramm = values;
                                  });
                                },
                                defaultSelected:
                                _localLadeKlimaKonfig.wiederholungLadeprogramm, // NUTZE DIE LOKALE KOPIE
                                horizontal: false,
                                selectedColor:
                                Theme.of(context).colorScheme.secondary,
                                padding: 5,
                                enableShape: true,
                              ),
                            ],
                          ),
                        ),
                      ),

                      Card(
                          child: Column(children: <Widget>[
                            const ListTile(
                              title: Text("Lade-Datum/Zeit"),
                            ),
                            Container(
                              child: Row(
                                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                children: [
                                  Text(context.sp.ladeDatumUhrzeitAnzeigen),
                                  Switch(
                                    activeColor: Colors.green,
                                    activeTrackColor: Colors.grey.shade400,
                                    inactiveThumbColor: Colors.red.shade600,
                                    inactiveTrackColor: Colors.grey.shade400,
                                    value: _localConfig.datumAnzeigeLaden, // NUTZE DIE LOKALE KOPIE
                                    onChanged: (val) {
                                      setState(() {
                                        _localConfig.datumAnzeigeLaden = val; // ÄNDERE DIE LOKALE KOPIE
                                      });
                                    },
                                  ),
                                ],
                              ),
                            ),

                            if (_localConfig.datumAnzeigeLaden) // NUTZE DIE LOKALE KOPIE
                              SizedBox(
                                height: size.height * 0.25,
                                child: CupertinoDatePicker(
                                  initialDateTime: setDateTime,
                                  use24hFormat: true,
                                  mode: CupertinoDatePickerMode.dateAndTime,
                                  onDateTimeChanged: (DateTime newDate) {
                                    setState(() {
                                      _localLadeKlimaKonfig.ladenDatumZeit = newDate; // ÄNDERE DIE LOKALE KOPIE
                                    });
                                  },
                                ),
                              ),
                          ])),
                    ]),
                  ),
                ))));
  }
}