import 'package:custom_radio_grouped_button/custom_radio_grouped_button.dart';
import 'package:daciapackete/globals.dart' as globals;
import 'package:daciapackete/speicherdaten.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:daciapackete/ladeklimakonfig.dart';
import 'main.dart';
class FormKlimaanlage extends StatefulWidget {
  const FormKlimaanlage({super.key});

  @override
  State<FormKlimaanlage> createState() => _FormKlimaanlageState();
}

class _FormKlimaanlageState extends State<FormKlimaanlage> {

 // var config =globals.config;
  var ladeKlimaKonfig = globals.ladeKlimaKonfig;
  var newDate;

  datenSpeichern() {
    setState(() {
      speicherDaten("arbeitsdaten");
    });
  }

  var inputValue;
  final _formKey = GlobalKey<FormState>();

  @override
  Widget build(BuildContext context) {

    context:
    context;
    final size = MediaQuery.of(context).size;
    return Scaffold(
        appBar: AppBar(
          title: Text(context.sp.klimaanlageProgrammieren),
          centerTitle: true,
          backgroundColor: Theme.of(context).colorScheme.inversePrimary,
        ),
        body: Center(
            //child: SingleChildScrollView(
            child: Form(
                key: _formKey,
                child: Column(
                  //mainAxisAlignment: MainAxisAlignment.start,
                  children: [
                   //++++++++++++++
                Card(
                child: Column(children: <Widget>[
                ListTile(
                title: Text(context.sp.klimaDatumZeit),
              //subtitle: Text(subheading),
              //trailing: Icon(Icons.favorite_outline),
            ),
            SizedBox(
              height: size.height * 0.25,
              child: CupertinoDatePicker(
                use24hFormat: true,
                mode: CupertinoDatePickerMode.dateAndTime,
                // initialDateTime: _selectedDate,
                onDateTimeChanged: (newDate) {
                  ladeKlimaKonfig.klimaDatumZeit = newDate;
                  setState(() {});
                },
              ),
            ),
            ]
        )
    ),
                    //++++++++++++++++++++

        Card(
            child: Padding(
                padding: const EdgeInsets.all(8),
                child: Column(children: <Widget>[
                Row(
                mainAxisAlignment: MainAxisAlignment.center,
                  children: <Widget>[
                    CustomRadioButton(
                      buttonTextStyle: const ButtonTextStyle(
                        selectedColor: Colors.white,
                        unSelectedColor: Colors.black,
                        textStyle: TextStyle(
                          fontSize: 16,
                        ),
                      ),
                      autoWidth: true,
                      enableButtonWrap: true,
                      wrapAlignment: WrapAlignment.center,
                      unSelectedColor: Theme.of(context).canvasColor,
                      buttonLables: const [
                        "Wiederholung",
                        "Einmalig",
                        //"Voll bis",
                      ],
                      buttonValues: const [
                        true,
                        false,
                        //"Wednesday",
                      ],
                      radioButtonValue: (values) {
                        ladeKlimaKonfig.wiederholungKlimaprogramm = values;
                      },
                      defaultSelected: globals.ladeKlimaKonfig.wiederholungKlimaprogramm,
                      horizontal: false,
                      width: 120,
                      // hight: 50,
                      selectedColor: Theme.of(context).colorScheme.secondary,
                      padding: 5,
                      enableShape: true,
                    ),

                    ]
                )
                ]
            )
            )
        ),
                    //+++++++++++++++++++

                    Card(
                        child: Padding(
                            padding: const EdgeInsets.all(8),
                            child: Column(children: <Widget>[
                              Row(
                                mainAxisAlignment: MainAxisAlignment.center,
                                children: <Widget>[
                                  ElevatedButton(
                                    onPressed: () {
                                      _formKey.currentState?.reset();
                                      Navigator.pop(context, false);
                                    },
                                    child: Text(context.sp.abbruch),
                                  ),
                                  const SizedBox(width: 25),
                                  ElevatedButton(
                                    onPressed: () {
                                      if (_formKey.currentState!.validate()) {

                                      } else {

                                      }
                                      ladeKlimaKonfig.klimaProgramm = KlimaProgramm.Beginnen_am;
                                      if (ladeKlimaKonfig.klimaDatumZeit.compareTo(DateTime.now()) < 0) {

                                        ladeKlimaKonfig.klimaProgramm = KlimaProgramm.Beginnen_am;
                                      }
                                      datenSpeichern();
                                      Navigator.pop(context, true);
                                    },
                                    child: Text(context.sp.speichern),
                                  )
                                ],
                              )
                            ])))
                  ],
                ))));
  }
}
