//Konfiguration des Systems muß nur bei Änderungen übermittelt werden!

import "package:daciapackete/config.dart";
import 'package:daciapackete/configproxyserver.dart';
import 'package:daciapackete/globals.dart' as globals;
import 'package:daciapackete/speicherdaten.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'main.dart';



class FormConfig extends StatefulWidget {
  const FormConfig({super.key});

  @override
  State<FormConfig> createState() => _FormConfigState();
}

class _FormConfigState extends State<FormConfig> {
  //var b1g, b2g;

  var sekundenRefreshScreen = globals.config.sekundenRefreshScreen;

  // var daciaAnmeldedaten = globals.daciaAnmeldedaten;

  datenSpeichern() {
    config.sekundenRefreshScreen = sekundenRefreshScreen;
    globals.config = config;
    speicherDaten("config");
  }

  var inputValue;
  final _formKey = GlobalKey<FormState>();
  var proxyValue = false;
  var logGenau = globals.config.logGenau;
  var klimastart100ProzentMax = globals.config.klimastart100ProzentMax;
  var erweiterteEinstellungen = globals.config.erweiterteEinstellungen;
  var zyklus = globals.config.zyklus;
  var immerKlimaVorLaden = globals.config.immerKlimaVorLaden;
  Config config = globals.config.copy();

  //ConfigProxyServer  configProxyServer = globals.configProxyServer.copy();

//  config.ladebegrenzungB1 = 66;
  // globals.config.ladebegrenzungB1 = 67;

  @override
  Widget build(BuildContext context) {
/*
    testLadebegrenzung(eingabeLadebegrenzung) {
      if ((eingabeLadebegrenzung == null) || (eingabeLadebegrenzung == 0)) {
        return context.sp.ladebegrenzungDarfNichtNullSein;
      } else {
        return null;
      }
    }
  */
    return PopScope(
        onPopInvokedWithResult: (didPop, result) async {
          await datenSpeichern();
          //dispose();
        },
        child: Scaffold(
            appBar: AppBar(
              title: Text(context.sp.konfiguration),
              centerTitle: true,
              backgroundColor: Theme.of(context).colorScheme.inversePrimary,
            ),
            body: Center(
                child: SingleChildScrollView(
                    child: Form(
                        key: _formKey,
                        child: Column(
                            //mainAxisAlignment: MainAxisAlignment.start,
                            children: [
                              Card(
                                  child: Padding(
                                      padding: const EdgeInsets.all(8),
                                      child: Column(children: <Widget>[
                                        // const ListTile(
                                        //   title: Text("Sonstiges"),
                                        // ),

//if (config.erweiterteEinstellungen == true) <Card> {
                                        Column(
                                          children: [
                                            //if (config
                                            //        .erweiterteEinstellungen ==
                                            //    true) ...[
                                            Card(
                                                child: Padding(
                                              padding: const EdgeInsets.all(8),
                                              child: Row(
                                                mainAxisAlignment:
                                                    MainAxisAlignment
                                                        .spaceBetween,
                                                children: [
                                                  Text(context
                                                      .sp.loglevelAusfuehrlich),
                                                  Switch(
                                                    activeColor: Colors.green,
                                                    activeTrackColor:
                                                        Colors.grey.shade400,
                                                    inactiveThumbColor:
                                                        Colors.red.shade600,
                                                    inactiveTrackColor:
                                                        Colors.grey.shade400,
                                                    value: logGenau,
                                                    onChanged: (value) {
                                                      if (logGenau == true) {
                                                        logGenau = false;
                                                      } else {
                                                        logGenau = true;
                                                      }
                                                      setState(() {
                                                        config.logGenau =
                                                            logGenau;
                                                      });
                                                    },
                                                  ),
                                                ],
                                              ),
                                            )),

                                            Card(
                                                child: Padding(
                                              padding: const EdgeInsets.all(8),
                                              child: Row(
                                                mainAxisAlignment:
                                                    MainAxisAlignment
                                                        .spaceBetween,
                                                children: [
                                                  Text(context.sp
                                                      .immerKlimastartVorDemLaden),
                                                  Switch(
                                                    activeColor: Colors.green,
                                                    activeTrackColor:
                                                        Colors.grey.shade400,
                                                    inactiveThumbColor:
                                                        Colors.red.shade600,
                                                    inactiveTrackColor:
                                                        Colors.grey.shade400,
                                                    value: immerKlimaVorLaden,
                                                    onChanged: (value) {
                                                      if (immerKlimaVorLaden ==
                                                          true) {
                                                        immerKlimaVorLaden =
                                                            false;
                                                      } else {
                                                        immerKlimaVorLaden =
                                                            true;
                                                      }
                                                      setState(() {
                                                        config.immerKlimaVorLaden =
                                                            immerKlimaVorLaden;
                                                      });
                                                    },
                                                  ),
                                                ],
                                              ),
                                            )),

                                            Card(
                                              child: Padding(
                                                padding:
                                                    const EdgeInsets.all(8),
                                                child: Column(
                                                  children: <Widget>[
                                                    TextFormField(
                                                      autocorrect: false,
                                                      keyboardType:
                                                          TextInputType.number,
                                                      maxLength: 3,
                                                      decoration: InputDecoration(
                                                          labelText: context.sp
                                                              .deltaMinutenBeimLaden),
                                                      initialValue:
                                                          ("${config.deltaLadeMinuten}"),
                                                      inputFormatters: [
                                                        FilteringTextInputFormatter
                                                            .digitsOnly
                                                      ],
                                                      validator:
                                                          (deltaLadeMinuten) {
                                                        if (deltaLadeMinuten!
                                                            .isEmpty) {
                                                          return context.sp
                                                              .bitteAnzahlDerDeltaMinutenAngeben;
                                                        }
                                                        return null;
                                                      },
                                                      onChanged:
                                                          (deltaLadeMinuten) =>
                                                              setState(
                                                        () => config
                                                                .deltaLadeMinuten =
                                                            int.parse(
                                                                deltaLadeMinuten),
                                                      ),
                                                    ),
                                                  ],
                                                ),
                                              ),
                                            ),
                                            Card(
                                              child: Padding(
                                                padding:
                                                    const EdgeInsets.all(8),
                                                child: Column(
                                                  children: <Widget>[
                                                    TextFormField(
                                                      autocorrect: false,
                                                      keyboardType:
                                                          TextInputType.number,
                                                      decoration: InputDecoration(
                                                          labelText: context.sp
                                                              .durchschnittsverbrauchInKW),
                                                      initialValue:
                                                          ("${config.durchschnittsVerbrauch}"),
                                                      inputFormatters: [
                                                        FilteringTextInputFormatter
                                                            .allow(RegExp(
                                                                r'(^\d*\.?\d*)')),
                                                      ],
                                                      validator: (dv) {
                                                        if (dv!.isEmpty) {
                                                          return context.sp
                                                              .bitteDenVerbrauchAngeben;
                                                        }
                                                        return null;
                                                      },
                                                      onChanged: (dv) =>
                                                          setState(
                                                        () => config
                                                                .durchschnittsVerbrauch =
                                                            double.parse(dv),
                                                      ),
                                                    ),
                                                  ],
                                                ),
                                              ),
                                            ),
                                            Card(
                                                child: Padding(
                                                    padding:
                                                        const EdgeInsets.all(8),
                                                    child: Column(
                                                        children: <Widget>[
                                                          TextFormField(
                                                              autocorrect:
                                                                  false,
                                                              keyboardType:
                                                                  TextInputType
                                                                      .number,
                                                              decoration:
                                                                  InputDecoration(
                                                                      labelText:
                                                                          context
                                                                              .sp
                                                                              .abfragezyklusInMinuten),
                                                              initialValue: (config
                                                                  .zyklus
                                                                  .toString()),
                                                              validator:
                                                                  (zyklusEingabe) {
                                                                if ((zyklusEingabe!
                                                                        .isEmpty) ||
                                                                    (int.parse(
                                                                            zyklusEingabe) <=
                                                                        0)) {
                                                                  return context
                                                                      .sp
                                                                      .bitteEineZahlGr0Eingeben;
                                                                } else {
                                                                  if (int.parse(
                                                                          zyklusEingabe) !=
                                                                      globals
                                                                          .config
                                                                          .zyklus) {
                                                                    globals.config
                                                                            .zyklus =
                                                                        int.parse(
                                                                            zyklusEingabe);
                                                                    return context
                                                                        .sp
                                                                        .bitteAppBeendenUndNeuStarten;
                                                                  } else {
                                                                    return null;
                                                                  }
                                                                }
                                                              },
                                                              onChanged:
                                                                  (zyklusEingabe) {
                                                                config.zyklus =
                                                                    int.parse(
                                                                        zyklusEingabe);
                                                                setState(() {});
                                                              }),
                                                        ]))),

                                            Card(
                                              child: Padding(
                                                padding:
                                                    const EdgeInsets.all(8),
                                                child: Column(
                                                  children: <Widget>[
                                                    TextFormField(
                                                      autocorrect: false,
                                                      keyboardType:
                                                          TextInputType.number,
                                                      maxLength: 3,
                                                      decoration: InputDecoration(
                                                          labelText: context.sp
                                                              .zeitRefreshScreenInSekunden),
                                                      initialValue:
                                                          ("${config.sekundenRefreshScreen}"),
                                                      inputFormatters: [
                                                        FilteringTextInputFormatter
                                                            .digitsOnly
                                                      ],
                                                      validator: (srs) {
                                                        if ((srs!.isEmpty) ||
                                                            (int.parse(srs) <=
                                                                0)) {
                                                          return context.sp
                                                              .bitteEineZahlGr0Eingeben;
                                                        } else {
                                                          if (int.parse(srs) !=
                                                              globals.config
                                                                  .sekundenRefreshScreen) {
                                                            globals.config
                                                                    .sekundenRefreshScreen =
                                                                int.parse(srs);
                                                            return context.sp
                                                                .bitteAppBeendenUndNeuStarten;
                                                          } else {
                                                            return null;
                                                          }
                                                        }
                                                      },
                                                      onChanged: (srs) {
                                                        sekundenRefreshScreen =
                                                            int.parse(srs);
                                                        setState(() {});
                                                      },
                                                    ),
                                                  ],
                                                ),
                                              ),
                                            ),

                                            Card(
                                              child: Padding(
                                                padding:
                                                    const EdgeInsets.all(8),
                                                child: Column(
                                                  children: <Widget>[
                                                    TextFormField(
                                                      autocorrect: false,
                                                      keyboardType:
                                                          TextInputType.number,
                                                      maxLength: 2,
                                                      decoration: InputDecoration(
                                                          labelText: context.sp
                                                              .zeitDatenabrufNachBefehlInSekunden),
                                                      initialValue:
                                                          ("${config.sekundenBefehl}"),
                                                      inputFormatters: [
                                                        FilteringTextInputFormatter
                                                            .digitsOnly
                                                      ],
                                                      validator: (sb) {
                                                        if (sb!.isEmpty) {
                                                          return context.sp
                                                              .bitteEineZahlGr0Eingeben;
                                                        }
                                                        return null;
                                                      },
                                                      onChanged: (sb) =>
                                                          setState(
                                                        () => config
                                                                .sekundenBefehl =
                                                            int.parse(sb),
                                                      ),
                                                    ),
                                                  ],
                                                ),
                                              ),
                                            ),

                                            Card(
                                              child: Padding(
                                                padding:
                                                    const EdgeInsets.all(8),
                                                child: Column(
                                                  children: <Widget>[
                                                    TextFormField(
                                                      autocorrect: false,
                                                      keyboardType:
                                                          TextInputType.number,
                                                      maxLength: 3,
                                                      decoration:
                                                          InputDecoration(
                                                              //hintText: "Anzahl der Minuten die ",
                                                              labelText: context
                                                                  .sp
                                                                  .programmAusOhneNeuinitInMinuten),
                                                      initialValue:
                                                          ("${config.neustartMinuten}"),
                                                      inputFormatters: [
                                                        FilteringTextInputFormatter
                                                            .digitsOnly
                                                      ],
                                                      validator:
                                                          (deltaLadeMinuten) {
                                                        if (deltaLadeMinuten!
                                                            .isEmpty) {
                                                          return context.sp
                                                              .bitteAnzahlDerDeltaMinutenAngeben;
                                                        }
                                                        return null;
                                                      },
                                                      onChanged:
                                                          (neustartMinuten) =>
                                                              setState(
                                                        () => config
                                                                .neustartMinuten =
                                                            int.parse(
                                                                neustartMinuten),
                                                      ),
                                                    ),
                                                  ],
                                                ),
                                              ),
                                            ),

                                            Card(
                                              child: Padding(
                                                padding:
                                                    const EdgeInsets.all(8),
                                                child: Column(
                                                  children: <Widget>[
                                                    TextFormField(
                                                      autocorrect: false,
                                                      keyboardType:
                                                          TextInputType.number,
                                                      maxLength: 4,
                                                      decoration: InputDecoration(
                                                          labelText: context.sp
                                                              .anzahlDerLogeintraege),
                                                      initialValue:
                                                          ("${config.loglaenge}"),
                                                      inputFormatters: [
                                                        FilteringTextInputFormatter
                                                            .digitsOnly
                                                      ],
                                                      validator: (ll) {
                                                        if (ll!.isEmpty) {
                                                          return context.sp
                                                              .bitteEineZahlGr0Eingeben;
                                                        }
                                                        return null;
                                                      },
                                                      onChanged: (ll) =>
                                                          setState(
                                                        () => config.loglaenge =
                                                            int.parse(ll),
                                                      ),
                                                    ),
                                                  ],
                                                ),
                                              ),
                                            ),

                                            Card(
                                              child: Padding(
                                                padding:
                                                    const EdgeInsets.all(8),
                                                child: Column(
                                                  children: <Widget>[
                                                    TextFormField(
                                                      autocorrect: false,
                                                      keyboardType:
                                                          TextInputType.number,
                                                      maxLength: 4,
                                                      decoration: InputDecoration(
                                                          labelText:
                                                              "Statistikeinträge"),
                                                      initialValue:
                                                          ("${config.statistikEintraege}"),
                                                      inputFormatters: [
                                                        FilteringTextInputFormatter
                                                            .digitsOnly
                                                      ],
                                                      validator: (statistik) {
                                                        if (statistik!
                                                            .isEmpty) {
                                                          return context.sp
                                                              .bitteEineZahlGr0Eingeben;
                                                        }
                                                        return null;
                                                      },
                                                      onChanged: (statistik) =>
                                                          setState(
                                                        () => config.statistikEintraege =
                                                            int.parse(
                                                                statistik),
                                                      ),
                                                    ),
                                                  ],
                                                ),
                                              ),
                                            ),

                                            // }
                                            //  ],
                                          ],
                                        ),
                                        // *******************************
                                      ]))),
                            ]))))));
  }
}
