import 'dart:async';

import 'package:daciapackete/globals.dart' as globals;
import 'package:daciapackete/speicherdaten.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:intl/intl.dart';
import 'package:springcontrol/showalertdialog.dart';
import "main.dart";
const version = "0.1";
//List globals.verbindungsart = ["a", "b", "c"];

class FormInfos extends StatefulWidget {
  const FormInfos({super.key});

  @override
  State<FormInfos> createState() => _FormInfosState();
}
/*
titel() {
  //print("Globals Formular logging");
  //print(globals.logging.verbindungen);
  if (globals.config.verbindungsart == true) {
    return " Timer Verbindung";
  } else {
    return "Workmanager verbindung";
  }
}
*/
class _FormInfosState extends State<FormInfos> {
  var title;
  //var verbindung = globals.config.verbindungsart;
  var clipboardZeilen = globals.logging.verbindungen.length;

  @override
  void initState() {
    super.initState();
    //callApi();

    Timer.periodic(Duration(seconds: globals.config.sekundenRefreshScreen),
        (timer) {
      //  Timer.periodic(Duration(minutes: 1), (timer) {
      //print(globals.verbindungen);
      //setState((){});
    });
    //
    // Timer.periodic(oneSecond, (Timer t) => setState((){}));
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text("Log der Verbindungen"), //Text(titel()),
        actions: [
          /*
          ElevatedButton(
            onPressed: () {
              String result =
                  globals.logging.verbindungen.sublist(0, 100).join('\n');
              //String result = globals.logging.verbindungen.join(', ');
              Clipboard.setData(ClipboardData(text: result));
              // Aktion hier hinzufügen
              print('Button gedrückt');
            },
            child: Text('Clipboard'),
          ),
          //],
          ElevatedButton(
            child: Text('Delete'),
            onPressed: () {
              globals.logging.verbindungen.clear();
              speicherDaten("logging");
            },
          ),

        */
        ],
        centerTitle: true,
        backgroundColor: Theme.of(context).colorScheme.inversePrimary,
      ),
      body: Padding(
        padding: const EdgeInsets.all(8.0),
        child: Column(
          mainAxisAlignment: MainAxisAlignment.spaceEvenly,
         children: <Widget>[
         //   Card(
              //child:
              Padding(
                padding: const EdgeInsets.all(8),
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: <Widget>[
                    ElevatedButton(
                      onPressed: () {
      if ( clipboardZeilen > globals.logging.verbindungen.length) {
        showAlertDialog(
            context, context.sp.zeilenFehler, context.sp.zeilenAnzahl(globals.logging.verbindungen.length), context.sp.ok);
      } else {
      String result = globals.logging.verbindungen
          .sublist(0, clipboardZeilen)
          .join('\n');
      Clipboard.setData(ClipboardData(text: result));
      };
      },

                      child: Text(context.sp.clipboard),
                    ),
      SizedBox(
        width: 50,
                  //  Expanded(
                    child: TextFormField(
                      autocorrect: false,
                      keyboardType: TextInputType.number,
                      maxLength: globals.logging.verbindungen.length.toString().length,
                      decoration:
                          InputDecoration(labelText: context.sp.zeilen),
                      initialValue: clipboardZeilen.toString(),
                      // ("${config.loglaenge}"),
                      inputFormatters: [FilteringTextInputFormatter.digitsOnly],
                      validator: (cz) {
                        if ((cz!.isEmpty) ||
                                (int.parse(cz) > globals.logging.verbindungen.length)){
                          return context.sp.bitte0KlzahlKleingeben(globals.logging.verbindungen.length);
                        }
                        return null;
                      },
                      onChanged: (cz) {
                          clipboardZeilen = int.parse(cz);
                      //  print("Zeilen: $clipboardZeilen");


                          setState((){});
  },
                    ),
                    ),
                    ElevatedButton(
                      child: Text(context.sp.delete),
                      onPressed: () {
                        globals.logging.verbindungen.clear();
                        globals.logging.verbindungen.insert(
                            0, "${DateFormat("dd.MM HH:mm").format(DateTime.now())} Log gelöscht");
                        speicherDaten("logging");
                      },
                    ),
                  ],
                ),
              ),
          //  ),
            Expanded(
              // child: Card(
              child: ListView.builder(
                //padding: const EdgeInsets.all(8.0),
                itemCount: globals.logging.verbindungen.length,
                itemBuilder: (context, index) {
                  return Text(globals.logging.verbindungen[index]);
                  //  );
                },
              ),
              // ),
            ),
          ],
        ),
      ),
    );
  }
}

/*
/*
      body: ListView.builder(
        itemCount: globals.logging.verbindungen.length,
        itemBuilder: (context, index) {
          return Text(globals.logging.verbindungen[index]);
        },
      ),
      */
 */

/*

/*
        actions: [
          Switch(
            activeColor: Colors.green,
            activeTrackColor: Colors.grey.shade400,
            //inactiveThumbColor: Colors.red.shade600,
            inactiveThumbColor: Colors.blue,
            inactiveTrackColor: Colors.grey.shade400,
            value: verbindung,
            onChanged: (val) {
              //Hive.box(themeBox).put('darkMode', !value);
              if (verbindung == true)
              { verbindung = false;}
              else
              {verbindung = true;}

              setState(() {
                globals.config.verbindungsart= verbindung;
              speicherDaten("config");
              });
              showDialog<String>(
                  context: context,
                  builder: (BuildContext context) =>
              AlertDialog(
                title: const Text('Änderung Verbindungsart'),
                content: const Text(
                    'App unbedingt beenden und neu Starten!'),
                actions: <Widget>[
                  TextButton(
                    onPressed: () =>
                        Navigator.pop(context, 'OK'),
                    child: const Text('OK'),
                  ),
                ],
              ),
              );
            },
          ),
        ],
*/
 */
