import 'package:flutter/material.dart';

showAlertDialog(BuildContext context, String titel, String body, String button) {
  showDialog<String>(
    context: context,
    builder: (BuildContext context) =>
        AlertDialog(
          title:  Text(titel),
          content: Text(body),
          actions: <Widget>[
             TextButton(
               onPressed: () =>
                  Navigator.pop(context),
               child:  Text(button),
             ),
          ],
        ),
  );

  /*
  // set up the AlertDialog
  AlertDialog alert = AlertDialog(
    title: Text(titel),
    content: Text(body),
    actions: [
       TextButton(
         onPressed: () =>
            Navigator.pop(context, "aa"),
           child: const Text('OKyy'),
       ),
      //okButton,
    ],
  );

  // show the dialog
  showDialog(
    context: context,
    builder: (BuildContext context) {
      return alert;
    },
  );
  */
}

Future<bool> showConfirmationDialog(BuildContext context, String title, String message,
) async {
  String yesText = "Ja";
      String noText = "Nein";
  return await showDialog<bool>(
    context: context,
    barrierDismissible: false, // Verhindert Schließen durch Tippen außerhalb
    builder: (BuildContext context) {
      return AlertDialog(
        title: Text(title),
        content: Text(message),
        actions: <Widget>[
          // Nein-Button
          TextButton(
            onPressed: () => Navigator.pop(context, false),
            child: Text(noText),
          ),

          // Ja-Button
          TextButton(
            onPressed: () => Navigator.pop(context, true),
            child: Text(
              yesText,
              style: TextStyle(color: Theme.of(context).primaryColor),
            ),
          ),
        ],
      );
    },
  ) ?? false; // Fallback für Null (wenn Dialog anders geschlossen wird)
}