//import 'package:dacia11/ladedaten.dart';
//import 'package:springcontrol/timerhintergrund.dart';
import 'package:daciapackete/globals.dart' as globals;
import 'package:daciapackete/speicherdaten.dart';
import 'package:flutter/material.dart';
import "package:intl/intl.dart";
import 'package:springcontrol/showalertdialog.dart';
//import 'package:daciapackete/auswertungen.dart';
import "form_datumzeit_setzen.dart";
import 'package:daciapackete/logging.dart' as logging;
import 'package:daciapackete/ladeklimakonfig.dart';
import "package:daciapackete/sequenzen.dart";
import 'main.dart';
/*
class CardLadenProgrammieren extends StatefulWidget {
  // const CardLadenProgrammieren({super.key, required this.speichern});
  final Function() speichern;
  CardLadenProgrammieren(this.speichern);
  @override
  State<CardLadenProgrammieren> createState() => _CardLadenProgrammierenState();
}
*/

class KlimaStarten extends StatefulWidget {
  const KlimaStarten({super.key});

//final Function() setStateMain;
//  KlimaStarten(this.setStateMain);

  @override
  State<KlimaStarten> createState() => _KlimaStartenState();
}

Widget zeileAnzeigen(String textLinks, String wertRechts) {
  return Card(
    child: Padding(
      padding: const EdgeInsets.all(8),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: <Widget>[
          Text(textLinks),
          Text(wertRechts),
          //Text("${pet.age} Jahre"),
        ],
      ),
    ),
  );
}



klimaZeit() {
  //print("klimazeit1");
  if (globals.ladeKlimaKonfig.klimaProgramm == KlimaProgramm.Kein_Programm) {
    return "";
  } else {
    return DateFormat("dd.MM.yyyy HH:mm").format(globals.ladeKlimaKonfig.klimaDatumZeit);
  }
}

var datumZeit = DatumZeit("hallo1", "hallo2");


/*
ausfuehrung() async {
  await Auswertungen().auswertungKlimamanagement();
  await ladeAutodaten();
}
*/
class _KlimaStartenState extends State<KlimaStarten> {
 // var config = globals.config;
  klimaWiederholungText() {
    //print("klimawiederhol1");
    if (true == globals.ladeKlimaKonfig.wiederholungKlimaprogramm) {
      return context.sp.ja;
    } else {
      return context.sp.nein;
    }
  }
  klimaTest() {
    if (globals.autoInfos.hvacStatus.hvacStatus == "off") {
      if (globals.arbeitsdaten.befehlKlimaStart > 0) {
        return context.sp.klimastartGesendet(globals.arbeitsdaten.befehlKlimaStart);
      } else {
        if (globals.ladeKlimaKonfig.klimaSofortStarten == true) {
          return context.sp.klimastartAufgenommen;
        } else {
          return context.sp.aus;
        }
      }
    } else {
      return context.sp.an;
    }
  }
  @override
  Widget build(BuildContext context) {
    return Card(
      child: Padding(
        padding: const EdgeInsets.all(8),
        child: Column(
          children: <Widget>[
            ListTile(
              title: Text(context.sp.klimaanlage),
              //subtitle: Text(subheading),
              //trailing: Icon(Icons.favorite_outline),
            ),
            Card(
              child: Padding(
                padding: const EdgeInsets.all(8),
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: <Widget>[
                    Text(klimaZeit()),
                    Text(context.sp.wiederholung),
                    Text(klimaWiederholungText()),
                  ],
                ),
              ),
            ),
            Card(
              child: Padding(
                padding: const EdgeInsets.all(8),
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: <Widget>[
                    Text(context.sp.klimaanlageHeizung),
                    Text(klimaTest()),
                  ],
                ),
              ),
            ),
            Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: <Widget>[
                ElevatedButton(
                  child: Text(context.sp.sofortStarten),
                  onPressed: () {
                    globals.ladeKlimaKonfig.klimaSofortStarten = true;
                    //globals.arbeitsdaten.befehlGegeben = true;
                    globals.logging.insertElement("Klima sofort Start Button gedrückt");
                    speicherDaten("ladeKlimaKonfig");
                   //ablauf();
                    ladenAuswertungAusfuehrung();
                    showAlertDialog(
                        context, "Befehl", "Klima Starten wurde gesendet" , "ok");
                  },

                ),
                ElevatedButton(
                child: const Text("Klimastart Einrichten"),
                    onPressed: () async {
                      var ergebnis = await Navigator.pushNamed(
                          context, "/FormKlimaanlage",
                          arguments: datumZeit);
                      if (true == ergebnis) {
                        setState(() {});
                      }
                    },
                )
              ],
            ),
          ],
        ),
      ),
    );
  }
}
