
//Hier ist ein Dart-Skript, das die Build-Nummer in deiner pubspec.yaml-Datei erhöht:import 'dart:io';
import 'dart:io';
import 'package:yaml/yaml.dart';
import 'package:collection/collection.dart'; // Für die Funktion copyMap

void main() async {
  final File pubspecFile = File('pubspec.yaml');

  if (!await pubspecFile.exists()) {
    print('Fehler: Die Datei pubspec.yaml wurde nicht gefunden.');
    exit(1);
  }

  try {
    // Lese den Inhalt der pubspec.yaml-Datei
    String content = await pubspecFile.readAsString();
    // Parse den Inhalt als YAML
    final yamlMap = loadYaml(content);

    // Stelle sicher, dass wir mit einer veränderbaren Map arbeiten
    Map<dynamic, dynamic> mutableYamlMap = Map.from(yamlMap);


    // Prüfe, ob das Feld 'version' existiert
    if (mutableYamlMap.containsKey('version')) {
      // Hole die aktuelle Versionsnummer
      String version = mutableYamlMap['version'];
      // Teile die Versionsnummer in Basisversion und Build-Nummer auf
      List<String> parts = version.split('+');
      String baseVersion = parts[0];
      int buildNumber = 0;

      // Wenn eine Build-Nummer vorhanden ist, parse sie
      if (parts.length > 1) {
        try {
          buildNumber = int.parse(parts[1]);
        } catch (e) {
          print('Fehler beim Parsen der Build-Nummer: $e');
          exit(1);
        }
      }

      // Erhöhe die Build-Nummer
      buildNumber++;
      // Erstelle die neue Versionsnummer
      String newVersion = '$baseVersion+$buildNumber';
      // Aktualisiere die Versionsnummer im YAML-Objekt
      mutableYamlMap['version'] = newVersion;

      // Konvertiere das YAML-Objekt zurück in einen String mit korrekter Formatierung
      String newContent = _encodeYaml(mutableYamlMap);
      // Schreibe den aktualisierten Inhalt zurück in die pubspec.yaml-Datei
      await pubspecFile.writeAsString(newContent);

      print('Build-Nummer in pubspec.yaml erfolgreich auf $buildNumber erhöht.');
    } else {
      print('Das Feld "version" wurde in der pubspec.yaml nicht gefunden.');
      exit(1);
    }
  } catch (e) {
    // Fange alle Fehler beim Lesen oder Schreiben der Datei ab
    print('Fehler beim Lesen oder Schreiben der pubspec.yaml-Datei: $e');
    exit(1);
  }
}

// Funktion, um die YamlMap mit der ursprünglichen Formatierung zu kodieren
String _encodeYaml(Map yamlMap) { // Hier den Typ zu Map ändern
  StringBuffer buffer = StringBuffer();
  _writeYamlValue(buffer, yamlMap);
  return buffer.toString();
}

// Rekursive Funktion zum Schreiben von YAML-Werten
void _writeYamlValue(StringBuffer buffer, dynamic value, {int level = 0}) {
  if (value is Map) { // Und hier auch
    value.forEach((key, val) {
      _writeYamlString(buffer, key, level: level);
      buffer.write(':');
      if (val is List || val is Map) { // Und hier
        buffer.write('\n');
        _writeYamlValue(buffer, val, level: level + 1);
      } else {
        buffer.write(' ');
        _writeYamlValue(buffer, val);
        buffer.write('\n');
      }
    });
  } else if (value is List) {
    for (var val in value) {
      _writeYamlString(buffer, '-', level: level);
      buffer.write(' ');
      _writeYamlValue(buffer, val, level: level);
      buffer.write('\n');
    }
  } else {
    _writeYamlString(buffer, value);
  }
}

// Funktion zum Schreiben von YAML-Strings mit Einrückung
void _writeYamlString(StringBuffer buffer, Object obj, {int level = 0}) {
  for (int i = 0; i < level; i++) {
    buffer.write('  '); // Verwende 2 Leerzeichen für die Einrückung
  }
  buffer.write(obj);
}

