import 'package:flutter/material.dart';
import 'package:url_launcher/url_launcher.dart';

class FormHilfe extends StatelessWidget {
  const FormHilfe({super.key});

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: const Text('Link zur Hilfe'),
      ),
      body: Center(
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          children: [
            // Link als kopierbarer Text
            _buildLinkText(),

            const SizedBox(height: 20),

            // Button zum Öffnen des Links
            _buildOpenButton(),
          ],
        ),
      ),
    );
  }

  Widget _buildLinkText() {
    return const SelectableText(
      'https://springcontrol.ydns.eu/index.php?cat=App&page=Anleitung',
      style: TextStyle(
        fontSize: 20,
        color: Colors.blue,
        decoration: TextDecoration.underline,
      ),
    );
  }

  Widget _buildOpenButton() {
    return ElevatedButton.icon(
      icon: const Icon(Icons.open_in_browser),
      label: const Text('Link öffnen'),
      onPressed: () => _launchUrl(),
    );
  }

  Future<void> _launchUrl() async {
    final uri = Uri.parse('https://springcontrol.ydns.eu/');
    if (!await launchUrl(uri)) {
      throw Exception('Could not launch $uri');
    }
  }
}