import 'package:daciapackete/ladedaten.dart';
//import 'package:springcontrol/timerhintergrund.dart';
import 'package:daciapackete/auswertungen.dart';
import 'package:daciapackete/globals.dart' as globals;
import 'package:daciapackete/speicherdaten.dart';
import 'package:flutter/material.dart';
import 'package:intl/intl.dart' show DateFormat;
//import 'package:springcontrol/ladedaten.dart';
import 'package:daciapackete/logging.dart' as logging;
import 'package:daciapackete/ladeklimakonfig.dart';
import "package:daciapackete/sequenzen.dart";
import 'package:springcontrol/showalertdialog.dart';
import 'main.dart';


class CardLadenProgrammieren extends StatefulWidget {
  // const CardLadenProgrammieren({super.key, required this.speichern});
  final Function() refresh;
  const CardLadenProgrammieren(this.refresh, {super.key});
  @override
  State<CardLadenProgrammieren> createState() => _CardLadenProgrammierenState();
}



ladeZeit() {
  if (globals.ladeKlimaKonfig.ladeProgrammArt == LadeProgrammArt.Kein_Programm) {
    return "";
  } else {
    return DateFormat("dd.MM.yyyy HH:mm").format(globals.ladeKlimaKonfig.ladenDatumZeit);
  }
}
ausfuehrung() async {
  await Auswertungen().auswertungLademanagement(true);
  await holeAutodaten();
}

class _CardLadenProgrammierenState extends State<CardLadenProgrammieren> {

  ladenWiederholungText() {
    if (true == globals.ladeKlimaKonfig.wiederholungLadeprogramm) {
      return context.sp.ja;
    } else {
      return context.sp.nein;
    }
  }

  ladeprogrammArtText() {
    switch (globals.ladeKlimaKonfig.ladeProgrammArt) {
      case LadeProgrammArt.Kein_Programm:
        return context.sp.keinProgramm;
      case LadeProgrammArt.Beginnen_am:
        return context.sp.beginnenAm;
      case LadeProgrammArt.Beenden_am:
        return context.sp.beendenAm;
      case LadeProgrammArt.Beenden80_am:
        return context.sp.beenden80Am;
      default:
        return context.sp.unbekannt;
    }
  }

  @override
  Widget build(BuildContext context) {
    return Card(
      // key: globalkey,
      child: Padding(
        padding: const EdgeInsets.all(8),
        child: Column(
          mainAxisAlignment: MainAxisAlignment.spaceEvenly,
          children: <Widget>[
            ListTile(
              title: Text(context.sp.ladenProgrammieren),
            ),
            Card(
              child: Padding(
                padding: const EdgeInsets.all(8),
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: <Widget>[
                    Text(ladeprogrammArtText()),
                    Text(ladeZeit()),
                   // const Text("Wiederholung:"),
                   // Text(ladenWiederholungText()),
                  ],
                ),
              ),
            ),

            Card(
              child: Padding(
                padding: const EdgeInsets.all(8),
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: <Widget>[
                  //  Text(ladeprogrammArtText()),
                   // Text(ladeZeit()),
                    Text(context.sp.wiederholung),
                    Text(ladenWiederholungText()),
                  ],
                ),



              ),
            ),


            Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: <Widget>[
                  ElevatedButton(
                    child:  Text(context.sp.stop),
                    onPressed: () async  {
                      globals.ladeKlimaKonfig.stop = true;
                      await globals.logging.insertElement(context.sp.stopButtonGedrueckt);
                      await speicherDaten("ladeKlimaKonfig");
                      ladenAuswertungAusfuehrung();
                      showAlertDialog(
                          context, context.sp.befehl, context.sp.ladenStoppenWurdeGesendet ,
                          context.sp.ok);
                    },
                  ),
                  ElevatedButton(
                    child:  Text(context.sp.sofortLaden),
                    onPressed: () async {
                     // globals.ladeKlimaKonfig.sofortLaden = true;
                      globals.ladeKlimaKonfig.ladeProgrammArt = LadeProgrammArt.Beginnen_am;
                      globals.ladeKlimaKonfig.ladenDatumZeit = DateTime.now();
                      //globals.arbeitsdaten.befehlGegeben = true;
                      await globals.logging.insertElement(context.sp.sofortLadenButtonGedrueckt);
                      await speicherDaten("ladeKlimaKonfig");
                      await speicherDaten("arbeitsdaten");
                       //await  ausfuehrung();
                      await ladenAuswertungAusfuehrung();
                      showAlertDialog(
                          context, context.sp.befehl, context.sp.ladenStartenWurdeGesendet ,
                          context.sp.ok);
                      // if (globals.config.sofortLaden == true) {}
                     // timerNachBefehlOhne();
                    },
                  ),
                  ElevatedButton(
                    onPressed: () async {
                      var ergebnis = await Navigator.pushNamed(
                          context, "/FormLadeprogramm");
                      if (true == ergebnis) {
                        setState(() {});
                        widget.refresh.call();
                      }
                    },
                    child:  Text(context.sp.einrichten),
                  ),
                ])
          ],
        ),
      ),
    );
  }
}
