//import 'package:daciapackete/auto_infos.dart';
import 'package:daciapackete/ladeklimakonfig.dart';
import 'package:flutter/material.dart';
import 'package:daciapackete/globals.dart' as globals;
import 'package:intl/intl.dart';
//import 'package:based_battery_indicator/based_battery_indicator.dart';
//import 'package:battery_indicator/battery_indicator.dart';
import "package:daciapackete/sequenzen.dart";
//import 'package:flutter_gen/gen_l10n/app_localizations.dart';

import 'main.dart';

Widget zeileAnzeigen(String textLinks, String wertRechts) {
  //Anzeigen() {
  //print("Wereausgabe");
//print(textLinks);
//print(wertRechts);
  return Card(
    child: Padding(
      padding: const EdgeInsets.all(8),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: <Widget>[
          Text(textLinks),
          Text(wertRechts),
          //Text("${pet.age} Jahre"),
        ],
      ),
    ),
  );
}

Widget zeileAnzeigen3(String textLinks, String wertMitte, String wertRechts) {
  //Anzeigen() {
  //print("Wereausgabe");
//print(textLinks);
//print(wertRechts);
  return Card(
    child: Padding(
      padding: const EdgeInsets.all(8),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: <Widget>[
          Text(textLinks),
          Text(wertMitte),
          Text(wertRechts),

          //Text("${pet.age} Jahre"),
        ],
      ),
    ),
  );
}


String intToTimeLeft(int ladebegrenzung) {
  var battery = globals.autoInfos.batteryStatus;
  var h = 0;
  var m = 0;
  var min = battery.chargingRemainingTime;
if (battery.batteryLevel < ladebegrenzung) {
  min = (ladebegrenzung - battery.batteryLevel) *
      battery.chargingRemainingTime
      ~/
      (100 - battery.batteryLevel);
  } else {
  if (ladebegrenzung < 100){
    return "0:0";
  }
  }
    h = min ~/ 60;
    m = ((min - h * 60));
    var z1 ="";
    if (m< 10) { z1 = "0";}
  String result = "$h:$z1$m";
  return result;
}

String ladeendeUhrzeit (int ladebegrenzung) {
  var battery = globals.autoInfos.batteryStatus;
  var min = battery.chargingRemainingTime;
  if (battery.batteryLevel < ladebegrenzung) {
    min = (ladebegrenzung - battery.batteryLevel) *
        battery.chargingRemainingTime
        ~/
        (100 - battery.batteryLevel);
  } else {
    min = 0;
  }
  if (globals.ladeKlimaKonfig.ladeProgrammArt == LadeProgrammArt.Beenden_am) {
    return DateFormat("HH:mm").format(globals.ladeKlimaKonfig.ladenDatumZeit.subtract((Duration(minutes: min))));
  } else {
    return DateFormat("HH:mm").format(
        DateTime.now().add(Duration(minutes: min)));
  }
}



class CardAkkuanzeige extends StatefulWidget {
  const CardAkkuanzeige({super.key});

  @override
  State<CardAkkuanzeige> createState() => _CardAkkuanzeigeState();
}

class _CardAkkuanzeigeState extends State<CardAkkuanzeige> {


  @override
  Widget build(BuildContext context) {

    akkuAnzeige () {
//l10n(context).
      if (globals.arbeitsdaten.prozent100Fehler == true) {
        String gestartet;
        if (globals.arbeitsdaten.klimastart100ProzentGestartet) {
          gestartet = "ja";
        } else {
          gestartet = "nein";
        }
        return context.sp.akkuwertGeschaetzt(gestartet);
      }else {
        return context.sp.akkufuellstand;
        // return s1.akkufuellstand;
      }
    }

    return Card(
      //child:Row(
      child: Padding(
        padding: const EdgeInsets.all(8.0),
        child: Column(
          mainAxisAlignment: MainAxisAlignment.spaceEvenly,
          //mainAxisAlignment: MainAxisAlignment.center,
          children: [
            ListTile(
              title: Text(akkuAnzeige()),
              //subtitle: Text(subheading),
              //trailing: Icon(Icons.favorite_outline),
            ),
            // const Text ("aa"),
            Stack(
              children: [
                LinearProgressIndicator(
                  minHeight: 50,
                  value: globals.autoInfos.batteryStatus.batteryLevel.toDouble()/100.0, //0.3,

                  backgroundColor: Colors.red,
                  color: Colors.blue,
                ),
                SizedBox(
                  height: 50,
                  child: Center(
                      //heightFactor: 3,

                      child: Text(
                          "${globals.autoInfos.batteryStatus.batteryLevel}%",
                        style: DefaultTextStyle.of(context).style.apply(fontSizeFactor: 1.5),
                      )
                        ),
                ),
              ],
            ),
            //var zeitVoll = intToTimeLeft(100),
            //var zeitGrenze = intToTimeLeft(globals.config.ladebegrenzung);,
            zeileAnzeigen3(context.sp.vollIn, context.sp.stunden(intToTimeLeft(100)) ,
                          context.sp.uhr(ladeendeUhrzeit(100) )),
            //Text( "Charge RemainingTime ${globals.autoInfos.batteryStatus.chargingRemainingTime} min"),
             zeileAnzeigen3(context.sp.bis(globals.config.ladebegrenzung),
                            context.sp.stunden(intToTimeLeft(globals.config.ladebegrenzung)),
                            context.sp.uhr(ladeendeUhrzeit(globals.config.ladebegrenzung))),
    if (globals.ladeKlimaKonfig.ladeProgrammArt == LadeProgrammArt.Beenden_am) ...[
      zeileAnzeigen (context.sp.ladenBeginntUm,context.sp.uhr(ladeendeUhrzeit(globals.config.ladebegrenzung))),
    ],
            zeileAnzeigen( context.sp.reichweite,  context.sp.km(globals.autoInfos.batteryStatus.batteryAutonomy)),
            zeileAnzeigen( context.sp.kilometerstand,  context.sp.km(globals.autoInfos.cockpit.totalMileage)),
          ],

          // ],
        ),

        //)
      ),
    );
  }
}
