import "package:daciapackete/arbeitsdaten.dart";
import "package:daciapackete/batterystatus.dart";
import "package:daciapackete/cockpit.dart";
import "package:daciapackete/config.dart";
import 'package:daciapackete/configproxyserver.dart';
import "package:daciapackete/daciaanmeldedaten.dart";
import "package:daciapackete/daciabefehle.dart";
import 'package:daciapackete/globals.dart' as globals;
import "package:daciapackete/isarservice.dart";
import "package:daciapackete/location.dart";
import "package:daciapackete/mongodb.dart" as mongodb;
import "package:daciapackete/speicherdaten.dart";
import "package:daciapackete/ladeklimakonfig.dart";
import "package:daciapackete/hvac_status.dart";

//Holt die Daten vom Dacia-Server ab und speichert sie in die mongodb oder isadb
//wird beim Starten de programmes gemacht
ladeDaten() async {
  await ladeDaciadaten();
  await ladeeProxydaten();
  await ladeConfig();
  await ladeKlimaKonfigdaten();
  await ladeAutodaten();
  //await ladeArbeitsdaten();
}

ladeArbeitsdaten() async {
  //var arbeitsdaten;
  Arbeitsdaten? arbeitsdaten; // = null;
  arbeitsdaten = await Isarservice().loadArbeitsdaten();
  arbeitsdaten ??= Arbeitsdaten.create();
  globals.arbeitsdaten = arbeitsdaten;
}

ladeKlimaKonfigdaten() async {
  LadeKlimaKonfig? ladeKlimaKonfig; // = null;
  ladeKlimaKonfig = await Isarservice().loadLadeKlimaKonfigdaten();
  ladeKlimaKonfig ??= LadeKlimaKonfig.create();

  globals.ladeKlimaKonfig = ladeKlimaKonfig;

  Isarservice().saveLadeKlimaKonfigdaten(globals.ladeKlimaKonfig);

}

ladeDaciadaten() async {
  var daciaAnmeldedaten;
  //await Future.delayed(Duration(seconds: 15));
  daciaAnmeldedaten = await Isarservice().loadDaciaAnmeldedatenDB();
  if (daciaAnmeldedaten == null) {
    if (globals.daciaAnmeldedaten.proxyBenutzen == true) {
      var db = mongodb.openDB(globals.configProxyServer);
      daciaAnmeldedaten = await mongodb.getData(db, "DaciaAnmeldedaten");
      db.close();
    }
    daciaAnmeldedaten ??= DaciaAnmeldedaten.create();
  }
  globals.daciaAnmeldedaten = daciaAnmeldedaten;
  Isarservice().saveDaciaAnmeldedatenDB(globals.daciaAnmeldedaten);
}

ladeeProxydaten() async {
  var configProxyServer = await Isarservice().loadConfigProxyServer();
  configProxyServer ??= ConfigProxyServer.create();
  globals.configProxyServer = configProxyServer;
  Isarservice().saveConfigProxyServer(globals.configProxyServer);
}

ladeConfig() async {
  var config;
  var db;
  if (globals.daciaAnmeldedaten.proxyBenutzen == true) {
    db = mongodb.openDB(globals.configProxyServer);
    config = await mongodb.getData(db, "config");
    db.close();
  }
  if ((globals.daciaAnmeldedaten.proxyBenutzen) == false || (config == null)) {
    config = await Isarservice().loadConfigDB();
  }
  if (config == null) {
    config = Config.create();
    await Isarservice().saveConfigDB(config);
  }
  globals.config = config;
}

ladeAutodaten() async {
//  läd die Autodaten wenn kein Proxy direkt, an sonsten über den Proxy
  BatteryStatus? ergBattery;
  Cockpit? ergCockpit;
  Location? ergLocation;
  HvacStatus? ergKlima;
  if (globals.daciaAnmeldedaten.proxyBenutzen == false) {
    ergBattery = await DaciaBefehle().holeBattery();
    if (ergBattery != null) {
      globals.ladeKlimaKonfig.letzterKontakt = DateTime.now();
    }
    globals.ladeKlimaKonfig.letzteAbfrage = DateTime.now();
    speicherDaten("ladeKlimaKonfig");
    ergCockpit = await DaciaBefehle().holeCokpit();
    ergLocation = await DaciaBefehle().holeLocation();
    ergKlima = await DaciaBefehle().holeKlima();
  } else {
    var db = mongodb.openDB(globals.configProxyServer);
    ergBattery = await mongodb.getData(db, "batteryStatus");
    ergCockpit = await mongodb.getData(db, "cockpit");
    ergLocation = await mongodb.getData(db, "location");
    ergKlima = await mongodb.getData(db, "hvacStatus");
    db.close();
  }
  if (ergBattery == null) {
    ergBattery = await Isarservice().loadBatteryStatus();
    ergBattery ??= globals.autoInfos.batteryStatus;
  } else {}
  globals.autoInfos.batteryStatus = ergBattery;
  Isarservice().saveBatteryStatus(globals.autoInfos.batteryStatus);
  if (ergCockpit == null) {
    ergCockpit = await Isarservice().loadCockpit();
    if (ergCockpit == null) {
      
    }
  } else {
    globals.autoInfos.cockpit = ergCockpit;
    Isarservice().saveCockpit(globals.autoInfos.cockpit);
  }
  if (ergLocation == null) {
    ergLocation = await Isarservice().loadLocation();
    if (ergLocation == null) {
      
    }
  } else {
    globals.autoInfos.location = ergLocation;
    Isarservice().saveLocation(globals.autoInfos.location);
  }
  if (ergKlima == null) {
    ergKlima = await Isarservice().loadHvacStatus();
    if (ergKlima == null) {
      
    }
  } else {
    globals.autoInfos.hvacStatus = ergKlima;
    Isarservice().saveHvacStatus(globals.autoInfos.hvacStatus);
  }
  //speicherDaten("arbeitsdaten");
}

ladeDBAutodaten() async {
  globals.autoInfos.batteryStatus = await Isarservice().loadBatteryStatus();
  globals.autoInfos.cockpit = await Isarservice().loadCockpit();
  globals.autoInfos.location = await Isarservice().loadLocation();
  globals.autoInfos.hvacStatus = await Isarservice().loadHvacStatus();
}
