import 'package:flutter/material.dart';
import 'package:daciapackete/globals.dart' as globals;
import 'package:flutter/material.dart';
import "package:intl/intl.dart";
import 'main.dart';

class CardStatistik extends StatefulWidget {
  const CardStatistik({super.key});

  @override
  State<CardStatistik> createState() => _CardStatistikState();
}

class _CardStatistikState extends State<CardStatistik> {
  @override
  Widget build(BuildContext context) {
    return Card(
      // key: _formKey,
      child: Padding(
        padding: const EdgeInsets.all(8),
        child: Column(
          children: <Widget>[
            ListTile(
              title: Text("Statistik"),
              subtitle:  Text( "Seit letzter Ladung vom " + DateFormat("dd.MM.yyyy HH:mm").format(globals.statistik.fahrtListe[0].datum)) ),

           // if (globals.configProxyServer.proxyBenutzen == true) ...[
              Card(
                child: Padding(
                  padding: const EdgeInsets.all(8),
                  child: Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: <Widget>[
                      Text("Gefahrene km"),
                      Text(globals.statistik.gefahreneKmSeitLetzterLadung.toString()),
                    ],
                  ),
                ),
              ),
           // ],
            Card(
              child: Padding(
                padding: const EdgeInsets.all(8),
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: <Widget>[
                    Text("Verbrauch in KW:"),
                    Text(globals.statistik.verbrauchSeitLetzterLadung.toStringAsFixed(2)),
                  ],
                ),
              ),
            ),
            Card(
              child: Padding(
                padding: const EdgeInsets.all(8),
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: <Widget>[
                    Text("KW/100km"),
                    Text(globals.statistik.durchschnittsVerbrauchAktuelleLadung100km.toStringAsFixed(2)),
                  ],
                ),
              ),
            ),
            /*
            Card(
              child: Padding(
                padding: const EdgeInsets.all(16),
                child: Text(""),
              ),
            ),
            */
          ],
        ),
      ),
    );
  }
}
