import 'dart:io';
import 'package:yaml/yaml.dart';

buildnummer() async {
  final File pubspecFile = File('pubspec.yaml');

  if (await pubspecFile.exists()) {
    final String content = await pubspecFile.readAsString();
    final YamlMap yamlMap = loadYaml(content);

    if (yamlMap.containsKey('version')) {
      final String fullVersion = yamlMap['version'];
      print('Version: $fullVersion');
    } else {
      print('Das Feld "version" wurde in der pubspec.yaml nicht gefunden.');
    }
  } else {
    print('Die pubspec.yaml-Datei wurde nicht gefunden.');
  }
}