import "package:daciapackete/speicherdaten.dart";
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import "package:daciapackete/fahrt.dart";
import "package:daciapackete/statistik.dart";
import "package:daciapackete/globals.dart" as globals;
import 'showalertdialog.dart';


class FormFahrtTabelle extends StatelessWidget {
  const FormFahrtTabelle({super.key});

  /*
  void _copyHumanReadable(BuildContext context) {
    final buffer = StringBuffer();
    for (final fahrt in globals.statistik.fahrtListe) {
      buffer.writeln(
          'Datum: ${fahrt.datum.day}.${fahrt.datum.month}.${fahrt.datum.year}');
      buffer.writeln('Kilometer: ${fahrt.gefahreneKmSeitLadung} km');
      buffer.writeln('Geladen: ${fahrt.geladen.toStringAsFixed(2)} kWh');
      buffer.writeln(
          'Verbrauch: ${fahrt.durchschnittsverbrauch.toStringAsFixed(2)} kWh/100km');
      buffer.writeln('---------------------');
    }

    Clipboard.setData(ClipboardData(text: buffer.toString()));
    ScaffoldMessenger.of(context).showSnackBar(
      const SnackBar(
        content: Text('Lesbares Format kopiert!'),
        duration: Duration(seconds: 2),
      ),
    );
  }


   */

  void _copyHumanReadable(BuildContext context) {
    final buffer = StringBuffer();

    buffer.writeln(' Datum      | Kilometer | kWh Geladen | kWh/100km ');
    buffer.writeln('------------+-----------+-------------+-----------');
    for (final fahrt in globals.statistik.fahrtListe) {
      // Datum mit führenden Nullen
      final day = fahrt.datum.day.toString().padLeft(2, '0');
      final month = fahrt.datum.month.toString().padLeft(2, '0');
      final date = '$day.$month.${fahrt.datum.year}'.padRight(10);

      // Werte mit festen Breiten
      final km = fahrt.gefahreneKmSeitLadung.toString().padLeft(8);
      final geladen = fahrt.geladen.toStringAsFixed(2).padLeft(8);
      final verbrauch = fahrt.durchschnittsverbrauch.toStringAsFixed(2).padLeft(8);

      buffer.writeln('$date$km$geladen$verbrauch');
    }

    Clipboard.setData(ClipboardData(text: buffer.toString()));
    ScaffoldMessenger.of(context).showSnackBar(
      const SnackBar(
        content: Text('Tabellenformat kopiert!'),
        duration: Duration(seconds: 2),
      ),
    );
  }



  void _copyCsvFormat(BuildContext context) {
    final csv = StringBuffer();
    csv.writeln('Datum,Kilometer,kWh Geladen,kWh/100km');

    for (final fahrt in globals.statistik.fahrtListe) {
      csv.writeln(
          '${fahrt.datum.day}.${fahrt.datum.month}.${fahrt.datum.year},' // TT.MM.JJJJ
          '${fahrt.gefahreneKmSeitLadung},'
          '${fahrt.geladen.toStringAsFixed(2)},'
          '${fahrt.durchschnittsverbrauch.toStringAsFixed(2)}');
    }

    Clipboard.setData(ClipboardData(text: csv.toString()));
    ScaffoldMessenger.of(context).showSnackBar(const SnackBar(
      content: Text('CSV-Format kopiert!'),
      duration: Duration(seconds: 2),
    ));
  }

  @override
  Widget build(BuildContext context) {

    return Scaffold(
      appBar: AppBar(
        title: Text("Statistik"),
      ),
        // Wichtig: Scaffold als Root-Widget
      body: Container(
        margin: const EdgeInsets.all(8),
        padding: const EdgeInsets.all(8),
        decoration: BoxDecoration(
          color: Colors.white,
          borderRadius: BorderRadius.circular(8),
        ),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.stretch,
          children: [
            // Button-Zeile
            Row(
              mainAxisAlignment: MainAxisAlignment.end,
              children: [
                ElevatedButton(
                  child: Text("Copy Text"),
                  onPressed: globals.statistik.fahrtListe.isEmpty
                      ? null
                      : () => _copyHumanReadable(context),

                ),
                const SizedBox(width: 8),
                ElevatedButton(
                  child: Text("Copy CSV"),
                  onPressed: globals.statistik.fahrtListe.isEmpty
                      ? null
                      : () => _copyCsvFormat(context),
                ),
                const SizedBox(width: 8),
                ElevatedButton(
                  child: Text("Delete"),
                  onPressed: () async {
                    if (await showConfirmationDialog(context, "Frage", "Alles Löschen?")){
                    //if (ergebnis) {
                      globals.statistik.fahrtListe.clear();
                      globals.statistik.fahrtListe.insert(0, Fahrt.create());
                      await speicherDaten("statistik");
                    }
                  },
                ),

              ],
            ),

            // Tabelle
            Expanded(
              child: globals.statistik.fahrtListe.isEmpty
                  ? const Center(
                      child: Text('Keine Fahrten vorhanden',
                          style: TextStyle(color: Colors.grey)))
                  : SingleChildScrollView(
                      scrollDirection: Axis.horizontal,
                      child: DataTable(
                        columnSpacing: 20,
                        dataRowMinHeight: 40,
                        columns: const [
                          DataColumn(label: Text('Datum')),
                          DataColumn(label: Text('Kilometer')),
                          DataColumn(label: Text('kWh\nGeladen')),
                          DataColumn(label: Text('kWh/\n100km')),
                        ],
                        rows: globals.statistik.fahrtListe.map((fahrt) {
                          return DataRow(
                            cells: [
                              DataCell(Text(
                                  "${fahrt.datum.day}.${fahrt.datum.month}.${fahrt.datum.year}")),
                              DataCell(
                                  Text(fahrt.gefahreneKmSeitLadung.toString())),
                              DataCell(Text(fahrt.geladen.toStringAsFixed(2))),
                              DataCell(Text(fahrt.durchschnittsverbrauch
                                  .toStringAsFixed(2))),
                            ],
                          );
                        }).toList(),
                      ),
                    ),
            ),
          ],
        ),
      ),
    );
  }
}
/*
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import "package:daciapackete/fahrt.dart";
import "package:daciapackete/statistik.dart";
import "package:daciapackete/globals.dart" as globals;

class FormFahrtTabelle extends StatelessWidget {
  const FormFahrtTabelle({super.key});

  void _copyToClipboard(BuildContext context) {
    final csv = StringBuffer();
    // Header-Zeile
    csv.writeln('Datum,Kilometer,kWh Geladen,kWh/100km');

    // Datenzeilen
    for (final fahrt in globals.statistik.fahrtListe) {
      final date = '${fahrt.datum.day}.${fahrt.datum.month}.${fahrt.datum.year}';
      final km = fahrt.gefahreneKmSeitLadung.toString();
      final geladen = fahrt.geladen.toStringAsFixed(2);
      final verbrauch = fahrt.durchschnittsverbrauch.toStringAsFixed(2);
      csv.writeln('$date,$km,$geladen,$verbrauch');
    }

    Clipboard.setData(ClipboardData(text: csv.toString()));
    //Clipboard.setData(ClipboardData(text: csvData));
    ScaffoldMessenger.of(context).showSnackBar(
      const SnackBar(
        content: Text('Daten in Zwischenablage kopiert!'),
        duration: Duration(seconds: 2),
      ),
    );
  }

  @override
  Widget build(BuildContext context) {
    return Container(
        decoration: BoxDecoration(
        color: Colors.white,
        borderRadius: BorderRadius.circular(8),
    boxShadow: [
    BoxShadow(
    color: Colors.grey.withOpacity(0.2),
    spreadRadius: 2,
    blurRadius: 4,
    offset: const Offset(0, 2),
    ),
    ],
    ),
    margin: const EdgeInsets.all(8),
    padding: const EdgeInsets.all(12),
    child: Column(
    crossAxisAlignment: CrossAxisAlignment.stretch,
    children: [
    // Copy-Button-Zeile
    Row(
    mainAxisAlignment: MainAxisAlignment.end,
    children: [
    Tooltip(
    message: 'Daten kopieren',
    child: IconButton(
    icon: const Icon(Icons.content_copy, size: 24),
    color: Colors.blue[800],
    onPressed: globals.statistik.fahrtListe.isEmpty
    ? null
        : () => _copyToClipboard(context),
    ),
    ),
    ],
    ),

    // Tabelle oder Platzhalter
    Expanded(
    child: globals.statistik.fahrtListe.isEmpty
    ? const Center(
    child: Text(
    'Keine Fahrten vorhanden',
    style: TextStyle(fontSize: 16, color: Colors.grey),
    ),
    )
        : SingleChildScrollView(
    scrollDirection: Axis.horizontal,
    child: DataTable(
    columnSpacing: 24,
    dataRowHeight: 40,
    headingRowHeight: 40,
      columns: const [
        DataColumn(
          label: Text(
            'Datum',
            style: TextStyle(fontWeight: FontWeight.bold),
          ), // <- Geschlossene Klammer
        ), // <- Komma
        DataColumn(
          label: Text(
            'Kilometer',
            style: TextStyle(fontWeight: FontWeight.bold),
          ), // <- Geschlossene Klammer
        ), // <- Komma
        DataColumn(
          label: Text(
            'kWh Geladen',
            style: TextStyle(fontWeight: FontWeight.bold),
          ), // <- Geschlossene Klammer
        ), // <- Komma
        DataColumn(
          label: Text(
            'kWh/100km',
            style: TextStyle(fontWeight: FontWeight.bold),
          ), // <- Geschlossene Klammer
        ), // <- Letztes Komma optional
      ],
    rows: globals.statistik.fahrtListe.map<DataRow>((fahrt) {
    return DataRow(
    cells: [
    DataCell(Text(
    "${fahrt.datum.day}.${fahrt.datum.month}.${fahrt.datum.year}")),
    DataCell(Center(
    child: Text(fahrt.gefahreneKmSeitLadung.toString()))),
    DataCell(Center(
    child: Text(fahrt.geladen.toStringAsFixed(2)))),
    DataCell(Center(
    child: Text(fahrt.durchschnittsverbrauch.toStringAsFixed(2)))),
    ],
    );
    }).toList(),
    ),
    ),
    ),
    ],
    ),
    );
  }
}


 */
